  import java.applet.*;
  import java.awt.*;

  public class CoffeeApplet2 extends Applet
  {
      CoffeeVendingMachine cm = new CoffeeVendingMachine(5,0);

      public void init()
      {
	add(new Button("Insert Coin"));
        add(new Button("Request Coffee"));
      }

      public boolean action(Event evt, Object arg)
      {
	if (arg.equals("Insert Coin"))
	  cm.in10p();
        else if (arg.equals("Request Coffee"))
          cm.press();
        return true;
      }
  }

    class CoffeeVendingMachine
    {
      MoneyBox mb;
      Dispenser dp;
      CoinSlot cs;
      Manager mn;
      CoffeeButton cb;

      CoffeeVendingMachine(int l, int m)
      {
	dp = new Dispenser(l);
	mb = new MoneyBox(m);
	cs = new CoinSlot(mb);
	mn = new Manager(cs, dp);
	cb = new CoffeeButton(mn);
      }

      public void in10p()
      { cs.in10p(); }

      public void press()
      { cb.press(); }
    }

    class CoinSlot
    {
      private MoneyBox mb;
      private String msg;
      public int amount;

      CoinSlot (MoneyBox mb)
      { this.mb = mb; }

      public void in10p()
      {
	if (amount < 30)
	{
	  amount = amount + 10;
      	  msg = "Money: " + amount + ", Money In Box: " + mb.totalAmount;
	  System.out.println(msg);
	}
      }

      public void emptyslot()
      {
	mb.takeMoney(amount);
	amount = 0;
      }
    }

    class MoneyBox
    {
      private String msg;
      public int totalAmount;

      MoneyBox(int m)
      {
	totalAmount = m;
      }

      public void takeMoney(int amount)
      {
	totalAmount = totalAmount + amount;
	msg = "Coffee Dispensed!  Money In Box: " + totalAmount;
	System.out.println(msg);
      }

      public int getAmount()
      { return totalAmount; }
    }

    class Dispenser
    {
      public int coffeeLevel;

      Dispenser(int l)
      { coffeeLevel = l; }

      public void dispense()
      {
	coffeeLevel--;
      }
    }

    class Manager
    {
      private CoinSlot cs;
      private Dispenser dp;

      Manager(CoinSlot cs, Dispenser dp)
      {
	this.cs = cs;
	this.dp = dp;
      }

      public void handleCoffeeRequest()
      { if (cs.amount == 30 && dp.coffeeLevel > 0)
        { cs.emptyslot();
          dp.dispense();
        }
      }
    }

    class CoffeeButton
    {
      private Manager man;

      CoffeeButton(Manager m)
      { man = m; }

      public void press()
      { man.handleCoffeeRequest(); }
    }












