/*
Candidate Number - J1918

15th May 1997

Practical 4
===========

This is a virtual copy of the ParseApp.java file I created (the fully working
version I completed after the hand-in) for practical 4.  The difference is that
the public class is now getOutput instead of ParseApp.  This is why the file
has been renamed to getOutput.java.

*/

import java.awt.*;
import java.applet.*;
import java.util.*;

class GenerateAssignments
{
  BoolTerm b;
  public Vector asvec = new Vector();
  public Vector answervec = new Vector();
  private Assignments as;

  GenerateAssignments(BoolTerm b)
  {
    this.b = b;
    doAssignments();
  }

  private void doAssignments()
  {
    String vars [] = b.getVars();
    int n = vars.length;

    // begin with one empty assignment
    asvec.addElement(new Assignments());

    for (int i = 0; i < n; i++)
    {
      int asSize = asvec.size();

      // want to copy each current assignment to the end of the main vector
      for (int j = 0; j < asSize; j++)
      {
	Assignments asNew = new Assignments();
	Assignments as = (Assignments)asvec.elementAt(2 * j);
	
	// copy assignment - look for values of each variable used so far
	for (int k = 0; k < i; k++)
	  asNew.add(new VarVal(vars[k], as.valueOf(vars[k])));
	
	// add duplicated assignment to main vector
	asvec.insertElementAt(asNew, 2 * j + 1);
	
	// add true assignment of new variable to original assignments
	as.add(new VarVal(vars[i], false));
	// add false assignment of new variable to duplicated assignments
	asNew.add(new VarVal(vars[i], true));
      }
    }

    // evaluate each line in the truth table
    for (int i = 0; i < (asvec.size()); i++)
    {
      Assignments as = (Assignments)(asvec.elementAt(i));
      answervec.addElement
	(new Boolean(b.evaluate(as)));
    }
  }
}

class getOutput
{
  public String appendText = "";

  getOutput(String s)
  {
    BoolTerm t = Parse.parseString(s);
    String vars [] = t.getVars();
    int n = vars.length;
    int i,j;

    if (t == null)
      appendText = appendText + "cannot parse \"" + s + "\"\n\n";
    else
    { appendText = appendText + s + "  parses as: " + t.getString() + "\n\n";
      GenerateAssignments ga = new GenerateAssignments(t);

      // show truth table for BoolTerm

      // get gap between assignments and result
      String str = new String(t.getString());
      int gap = (str.length() + 1) / 2;

      // header
      for (i = 0; i < n; i++)
        appendText = appendText + vars[i]+ " ";
      appendText = appendText + " |  " + t.getString() + "\n";
      // separator between header and the rest
      for (i = 0; i < 2 * n + 1; i++)
	appendText = appendText + "-";
      appendText = appendText + "+";
      for (i = 0; i < (str.length() + 2); i++)
      	appendText = appendText + "-";
      appendText = appendText + "\n";

      // table contents
      for (i = 0; i < (1 << n); i++)
      {
	for (j = 0; j < n; j++)
	{
	  if (((Assignments)((ga.asvec).elementAt(i))).valueOf(vars[j]))
	    appendText = appendText + "t ";
	  else
	    appendText = appendText + "f ";
	}

	// separate assignments from evaluations
	appendText = appendText + " | ";
	for (j = 0; j < gap; j++)
	  appendText = appendText + " ";

	if (((Boolean)((ga.answervec).elementAt(i))).booleanValue())
	  appendText = appendText + "t\n";
	else
	  appendText = appendText + "f\n";
      }
      appendText = appendText + "\n";
    }
  }
}

class VarVal
{
  String boolname;
  boolean boolval;

  VarVal(String boolname, boolean boolval)
  {
    this.boolname = boolname;
    this.boolval = boolval;
  }

  public String getName()  // the string
  { return boolname; }

  public boolean getVal()  // the boolean value
  { return boolval; }
}

class Assignments
{
  private Vector VarValColl;

  Assignments()
  { VarValColl = new Vector(); }

  public Vector getVector()
  {
    return VarValColl;
  }

  public void add(VarVal vv)
  // adds a VarVal to the collection
  { VarValColl.addElement(vv); }

  public boolean isConsistent()
  // tests whether different boolean values
  // have been assigned to the same variable
  {
    for(int i = 0; i < VarValColl.size(); i++)
    {
      VarVal vv1 = (VarVal)VarValColl.elementAt(i);
      for(int j = i; j < VarValColl.size(); j++)
      {
        VarVal vv2 = (VarVal)VarValColl.elementAt(j);
	if ((vv2.getName() == vv1.getName()) && (vv2.getVal() != vv1.getVal()))
	  return false;
      }
    }
    return true;
  }

  public boolean isDefinedFor(String name)
  // tests whether the collection assigns a value
  // to name
  {
    for(int i = 0; i < VarValColl.size(); i++)
    {
      if (((VarVal)VarValColl.elementAt(i)).getName() == name)
        return true;
    }
    return false;
  }

  public boolean valueOf(String name)
  // gives the value assigned to name
  // if no value is assigned to name, returns false
  {
    for(int i = 0; i < VarValColl.size(); i++)
    {
      VarVal vv1 = (VarVal)VarValColl.elementAt(i);
      if (vv1.getName() == name)
        return vv1.getVal();
    }
    return false;
  }
}

class BoolTerm
{
  private Operator op;
  private BoolTerm[] args;

  BoolTerm(Operator o, BoolTerm[] a)
  { op = o; args = a; }

  public Operator getOp()
  { return op; }

  public String getString()
  { String s = "";
    switch (op.getArity())
    { case 0:
      {
	s = op.getName();
	break;
      }
      case 1:
      { s = op.getName();
        String s0 = args[0].getString();
        if (args[0].getOp().getArity() > 1)
          s = s+"("+s0+")";
        else s = s+s0;
        break;
      }
      case 2:
      { String s0 = args[0].getString();
        String s1 = args[1].getString();
        if (args[0].getOp().getArity() > 1)
          s = "("+s0+") "+op.getName()+" ";
        else s = s0+" "+op.getName()+" ";
        if (args[1].getOp().getArity() > 1)
          s = s+"("+s1+")";
        else s = s+s1;
        break;
      }
    }
    return s;
  }

  public BoolTerm copy()
  { int n = op.getArity();
    BoolTerm[] argCopies = new BoolTerm[n];
    for (int i = 0; i < n; i++)
    { argCopies[i] = args[i].copy(); }
    return new BoolTerm(op, argCopies);
  }

  public String[] getVars()
  { Vector v = getVarVector();
    int n = v.size();
    String[] vars = new String[n];
    for (int i=0; i < n; i++)
      vars[i] = v.elementAt(i).toString();
    return vars;
  }

  private Vector getVarVector()
  { Vector v = new Vector();
    switch (op.getArity())
    { case 0:
        if (Signature.isVarOp(op))
          v.addElement(op.getName());
        break;
      case 1:
        v = args[0].getVarVector();
	break;
      case 2:
      { v = args[0].getVarVector();
        Vector v1 = args[1].getVarVector();
        for (int i = 0; i < v1.size(); i++)
        { Object o = v1.elementAt(i);
          if (! v.contains(o))
            v.addElement(o);
        }
	break;
      }
    }
    return v;
  }

  public boolean evaluate(Assignments as)
  {
    if (Signature.isVarOp(op))
    {
      //System.out.println(as.toString());
      return as.valueOf(op.getName());
    }
    else
    {
      if (op == Signature.trueOp)
        return true;
      else if (op == Signature.falseOp)
        return false;
      else if (op == Signature.notOp)
        return !(args[0].evaluate(as));
      else if (op == Signature.andOp)
        return (args[0].evaluate(as) && args[1].evaluate(as));
      else if (op == Signature.orOp)
        return (args[0].evaluate(as) | args[1].evaluate(as));
      else if (op == Signature.xorOp)
        return (args[0].evaluate(as) ^ args[1].evaluate(as));
    }
    return true;
  }
}

class Operator
{
  private String name;
  private int arity;
  private int prec;

  Operator(String n, int a, int p)
  { name = n;
    arity = a;
    prec = p;
  }

  public int getArity()
  { return arity; }

  public String getName()
  { return name; }

  public int getPrecedence()
  { return prec; }
}

class Signature
{
  static int MaxPrec = 13;

  static Operator trueOp = new Operator("true",0,0);
  static Operator falseOp = new Operator("false",0,0);
  static Operator notOp = new Operator("!",1,0);
  static Operator andOp = new Operator("&",2,7);
  static Operator orOp = new Operator("|",2,9);
  static Operator xorOp = new Operator("^",2,8);

  static BoolTerm trueTerm = new BoolTerm(trueOp, new BoolTerm[0]);
  static BoolTerm falseTerm = new BoolTerm(falseOp, new BoolTerm[0]);

  Signature()
  { }

  static public BoolTerm mkTerm(Operator op, BoolTerm[] args)
  { return new BoolTerm(op, args); }

  static public BoolTerm makeVar(String s)
  { Operator op = new Operator(s,0,0);
    BoolTerm[] args = new BoolTerm[0];
    return new BoolTerm(op, args);
  }

  public static boolean isVarOp(Operator op)
  { if (  op.getName().equals("true")
       || op.getName().equals("false")
       || op.getName().equals("!")
       || op.getName().equals("&")
       || op.getName().equals("|")
       || op.getName().equals("^")
       ) return false;
    return true;
  }
}

public class ParseApp extends Applet
{
  static TextField input = new TextField();
  static TextArea report = new TextArea();
  
  // String appendText;  // text to be appended to "report"

  public void init()
  { setLayout(new BorderLayout());
    Panel p = new Panel();
    p.add(new Button("Parse"));
    p.add(new Button("Clear"));
    add("North", input);
    add("Center", report);
    add("South", p);
  }

  public boolean action(Event evt, Object arg)
  { if (arg.equals("Parse"))
    {
      getOutput output = new getOutput(input.getText());
      report.appendText(output.appendText);
    }
    else if (arg.equals("Clear"))
      input.setText("");
    return true;
  }
}

class Parse
{
  public static BoolTerm parseString(String s)
  { BoolTerm t;
    try { t = parseToPrec(Signature.MaxPrec, s).getTerm(); }
    catch (Exception e) { t = null; }
    return t;
  }

  private static ParseState parseToPrec(int prec, String s)
    throws ParseException, RParenParseException
  { ParseState ps;
    String str = s.trim(); // remove leading white space
    if (str.equals(""))
      throw new ParseException();
    String ch0 = str.substring(0,1);
    if (ch0.equals("!"))
    { Operator op = Signature.notOp;
      try
      { ps = parseToPrec(op.getPrecedence(), str.substring(1)); }
      catch (RParenParseException rpe)
      { rpe.getState().applyUOp(op);
        throw rpe;
      }
      ps.applyUOp(op);
    }
    else if (ch0.equals("("))
    { try
      { ps = parseToPrec(Signature.MaxPrec, str.substring(1)); }
      catch (RParenParseException rpe)
      { ps = rpe.getState(); }
      if (ps.getRemainder().equals("") || !(ps.firstChar().equals(")")))
        throw new RParenParseException(ps);
      else ps.advanceOneChar();
    }
    else ps = getLiteral(str);
    boolean done = ps.done();
    while (! done)
    { if (ps.firstChar().equals(")"))
      { throw new RParenParseException(ps); }
      OpState os = ps.readOp(); 
      str = os.getRemainder();
      if (os.getPrecedence() > prec)  break;
      ParseState ps1;
      try
      { ps1 = parseToPrec(os.getPrecedence(), os.getRemainder()); }
      catch (RParenParseException rpe)
      { throw new RParenParseException
                  (os.applyBOp(rpe.getState()));
      }
      ps = os.applyBOp(ps1);
      done = ps.done();
    }
    return ps;
  }

  private static ParseState getLiteral(String s)
    throws ParseException
  { String str = s.trim();
    int i = readWord(str);
    if (i <= 0) throw new ParseException();
    BoolTerm t;
    if (str.substring(0,i).equals("true")) t = Signature.trueTerm;
    else if (str.substring(0,i).equals("false")) t = Signature.falseTerm;
    else t = Signature.makeVar(str.substring(0,i));
    return new ParseState(t,str.substring(i).trim());
  }

  private static int readWord(String s)
  { String str = s;
    int length = str.length();
    String opString = "";
    int pos = 0;
    int theChar = str.charAt(0);
    while ((theChar >= 'a' && theChar <= 'z') ||
           (theChar >= 'A' && theChar <= 'Z') ||
           (theChar >= '0' && theChar <= '9'))
    { pos++;
      if (pos < length) theChar = str.charAt(pos);
      else break;
    }
    return pos;
  }

  private static ParseState read(ParseState ps, String s)
    throws ParseException
  { String str;
    try { str = ps.getRemainder().trim().substring(0,s.length()); }
    catch (Exception e)
    { throw new ParseException(); }
    if (str.equals(s))
      return new ParseState(ps.getTerm(),
                            ps.getRemainder().trim().substring(s.length()));
    else throw new ParseException();
  }
}

class ParseState
{
  private String remainder;
  private BoolTerm term;

  ParseState(BoolTerm t, String s)
  { remainder = s;
    term = t;
  }

  public BoolTerm getTerm()
  { return term; }

  public String getRemainder()
  { return remainder; }

  public boolean done()
  { return remainder.trim().equals(""); }

  public String firstChar()
  { return remainder.trim().substring(0,1); }

  public void advanceOneChar()
  { remainder = remainder.substring(1).trim(); }

  public void applyUOp(Operator op)
  { BoolTerm[] args = { term.copy() };
    term = Signature.mkTerm(op, args);
  }

  public OpState readOp()
    throws ParseException
  { String opStr = firstChar();
    OpState os;
    if (opStr.equals("&"))
      os = new OpState(Signature.andOp, term, remainder.trim().substring(1));
    else if (opStr.equals("|"))
      os = new OpState(Signature.orOp, term, remainder.trim().substring(1));
    else if (opStr.equals("^"))
      os = new OpState(Signature.xorOp, term, remainder.trim().substring(1));
    else
      throw new ParseException();
    return os;
  }

  public String getString()
  { return term.getString() + ", remainder " + remainder; }
}

class OpState
{
  private BoolTerm term;
  private Operator op;
  private String remainder;

  OpState(Operator o, BoolTerm t, String s)
  { term = t;
    op = o;
    remainder = s;
  }

  public Operator getOp()
  { return op; }

  public int getPrecedence()
  { return op.getPrecedence(); }

  public String getRemainder()
  { return remainder; }

  public ParseState applyBOp(ParseState ps)
  { BoolTerm[] args = { term.copy(), ps.getTerm().copy() };
    BoolTerm t = Signature.mkTerm(op, args);
    return new ParseState(t, ps.getRemainder());
  }
} 

class ParseException extends Exception
{ ParseException()
  { }
}

class RParenParseException extends ParseException
{
  ParseState pstate;

  RParenParseException(ParseState ps)
  { pstate = ps; }

  public ParseState getState()
  { return pstate; }
}

/*

The End

Candidate Number - J1918

*/

